<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\PlanVisitasPamec;
use App\Models\clientes\AuditoriaPamecAcreditacion;
use App\Models\clientes\AuditoriaPamecOtros;

use App\Jobs\IndicadoresPamecJob;

class AuditoriaPamecController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentoVisita(Request $request, $idVisita) {
        $esAcreditacion = PlanVisitasPamec::on($this->cliente)->where('plv_pk_id', $idVisita)->pluck('plv_es_acreditacion')[0];

        if ($esAcreditacion) {
            return AuditoriaPamecAcreditacion::on($this->cliente)
                                             ->selectRaw('iap_fk_id, aup_instrumento, true as es_acreditacion')
                                             ->where('plv_fk_id', $idVisita)
                                             ->get()->toArray();
        }

        return AuditoriaPamecOtros::on($this->cliente)
                                  ->selectRaw('iap_fk_id, aup_prg_enf_1, aup_prg_enf_1_calificacion, aup_prg_enf_2,
                                               aup_prg_enf_2_calificacion, aup_prg_enf_3, aup_prg_enf_3_calificacion,
                                               aup_instrumento, false as es_acreditacion')
                                  ->where('plv_fk_id', $idVisita)
                                  ->get()->toArray();
    }
}
