<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Models\clientes\EstadoConsolidacionIndicadores;

use App\Http\Controllers\API\IndicadoresAuditoriaPamecController;

use App\Http\Services\DBClientConnection;


class ConsolidacionIndicadoresController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerEstadoConsolidacion(Request $request) {
        return EstadoConsolidacionIndicadores::on($this->cliente)
                                             ->orderBy('eci_ano')
                                             ->orderBy('eci_mes')
                                             ->get()->toArray();
    }

    public function consolidarIndicadores(Request $request, $ano, $mes) {
        DB::connection($this->cliente)->transaction(function() use($ano, $mes) {
            // CALIDAD

            // PAMEC
            $indicadoresPamec = new IndicadoresAuditoriaPamecController();
            $indicadoresPamec->establecerCliente($this->cliente);
            $indicadoresPamec->actualizarIndicadoresGlobales($ano, $mes);
            $indicadoresPamec->actualizarIndicadoresAcreditacion($ano, $mes);
            $indicadoresPamec->actualizarIndicadoresOtrosEnfoques($ano, $mes);

            // RIAS

            // SUH 3100
            $indicadoresSuh3100 = new IndicadoresAuditoriaPamecController();
            $indicadoresSuh3100->establecerCliente($this->cliente);

            $suh3100request = new Request();
            $suh3100request->setMethod('POST');
            $suh3100request->request->add(['ano' => $ano, 'mes' => $mes]);

            $indicadoresSuh3100->actualizarIndicadores($suh3100request);

            // Actualizacion de la fecha de la consolidación
            $this->actualizarFechaConsolidacion($ano, $mes);
        });
    }

    private function actualizarFechaConsolidacion($ano, $mes) {
        $registro = EstadoConsolidacionIndicadores::on($this->cliente)
                                                  ->where('eci_ano', $ano)
                                                  ->where('eci_mes', $mes)
                                                  ->get()->toArray();

        if (count($registro) > 0) {
            EstadoConsolidacionIndicadores::on($this->cliente)->where('eci_pk_id', $registro[0]['eci_pk_id'])->update([
                'eci_auditoria_calidad' => 'now()',
                'eci_auditoria_pamec' => 'now()',
                'eci_auditoria_rias' => 'now()',
                'eci_suh_3100' => 'now()'
            ]);
        } else {
            EstadoConsolidacionIndicadores::on($this->cliente)->create([
                'eci_ano' => $ano,
                'eci_mes' => $mes,
                'eci_auditoria_calidad' => 'now()',
                'eci_auditoria_pamec' => 'now()',
                'eci_auditoria_rias' => 'now()',
                'eci_suh_3100' => 'now()'
            ]);
        }
    }
}
