<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Models\clientes\EstadoConsolidacionIndicadores;

use App\Http\Services\DBClientConnection;

class IndicadoresSuh3100Controller extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function establecerCliente($cliente) {
        $this->cliente = $cliente;
    }

    public function obtenerIndicadores(Request $request, $ano, $mes, $municipio, $prestador, $sede, $codigoServicio, $visita) {
        $parametros = [];
        $where = "";

        // Ano
        if (intval($ano) !== -1) {
            $where .= "isu_ano = ?";
            array_push($parametros, $ano);
        }

        // Mes
        if (intval($mes) !== -1) {
            if ($where !== "") { $where .= " and "; }
            $where .= "isu_mes = ?";
            array_push($parametros, $mes);
        }

        // Municipio
        if ($where !== "") { $where .= " and "; }
        $where .= "mun_fk_id = ?";
        array_push($parametros, $municipio);

        // Prestador
        if ($where !== "") { $where .= " and "; }
        $where .= "rpr_fk_id = ?";
        array_push($parametros, $prestador);

        // Sede
        if ($where !== "") { $where .= " and "; }
        $where .= "rps_fk_id = ?";
        array_push($parametros, $sede);

        // Sede
        if ($where !== "") { $where .= " and "; }
        $where .= "srv_codigo_servicio = ?";
        array_push($parametros, $codigoServicio);

        // Visita
        if ($where !== "") { $where .= " and "; }
        $where .= "plv_fk_id = ?";
        array_push($parametros, $visita);

        return DB::connection($this->cliente)->select("
            select coalesce(sum(isu_visitas_programadas), 0) as isu_visitas_programadas,
                   coalesce(sum(isu_visitas_por_realizar), 0) as isu_visitas_por_realizar,
                   coalesce(sum(isu_visitas_por_realizar) / nullif(cast(sum(isu_visitas_programadas) as float), 0), 0) * 100 as isu_prc_visitas_por_realizar,
                   coalesce(sum(isu_visitas_realizadas), 0) as isu_visitas_realizadas,
                   coalesce(sum(isu_visitas_realizadas) / nullif(cast(sum(isu_visitas_programadas) as float), 0), 0) * 100 as isu_prc_visitas_realizadas,
                   coalesce(sum(isu_visitas_efectivas), 0) as isu_visitas_efectivas,
                   coalesce(sum(isu_visitas_efectivas) / nullif(cast(sum(isu_visitas_realizadas) as float), 0), 0) * 100 as isu_prc_visitas_efectivas,
                   coalesce(sum(isu_visitas_no_efectivas), 0) as isu_visitas_no_efectivas,
                   coalesce(sum(isu_visitas_no_efectivas) / nullif(cast(sum(isu_visitas_realizadas) as float), 0), 0) * 100 as isu_prc_visitas_no_efectivas,
                   coalesce(sum(isu_total_preguntas), 0) as isu_total_preguntas,
                   coalesce(sum(isu_total_cumple), 0) as isu_total_cumple,
                   coalesce(sum(isu_total_cumple_na), 0) as isu_total_cumple_na,
                   coalesce(sum(isu_total_na), 0) as isu_total_na,
                   coalesce(sum(isu_total_no_cumple), 0) as isu_total_no_cumple,
                   coalesce(sum(isu_total_no_verificado), 0) as isu_total_no_verificado,
                   coalesce(sum(isu_thu_total_preguntas), 0) as isu_thu_total_preguntas,
                   coalesce(sum(isu_thu_total_cumple), 0) as isu_thu_total_cumple,
                   coalesce(sum(isu_thu_total_cumple_na), 0) as isu_thu_total_cumple_na,
                   coalesce(sum(isu_thu_total_na), 0) as isu_thu_total_na,
                   coalesce(sum(isu_thu_total_no_cumple), 0) as isu_thu_total_no_cumple,
                   coalesce(sum(isu_thu_total_no_verificado), 0) as isu_thu_total_no_verificado,
                   coalesce(sum(isu_inf_total_preguntas), 0) as isu_inf_total_preguntas,
                   coalesce(sum(isu_inf_total_cumple), 0) as isu_inf_total_cumple,
                   coalesce(sum(isu_inf_total_cumple_na), 0) as isu_inf_total_cumple_na,
                   coalesce(sum(isu_inf_total_na), 0) as isu_inf_total_na,
                   coalesce(sum(isu_inf_total_no_cumple), 0) as isu_inf_total_no_cumple,
                   coalesce(sum(isu_inf_total_no_verificado), 0) as isu_inf_total_no_verificado,
                   coalesce(sum(isu_dot_total_preguntas), 0) as isu_dot_total_preguntas,
                   coalesce(sum(isu_dot_total_cumple), 0) as isu_dot_total_cumple,
                   coalesce(sum(isu_dot_total_cumple_na), 0) as isu_dot_total_cumple_na,
                   coalesce(sum(isu_dot_total_na), 0) as isu_dot_total_na,
                   coalesce(sum(isu_dot_total_no_cumple), 0) as isu_dot_total_no_cumple,
                   coalesce(sum(isu_dot_total_no_verificado), 0) as isu_dot_total_no_verificado,
                   coalesce(sum(isu_med_total_preguntas), 0) as isu_med_total_preguntas,
                   coalesce(sum(isu_med_total_cumple), 0) as isu_med_total_cumple,
                   coalesce(sum(isu_med_total_cumple_na), 0) as isu_med_total_cumple_na,
                   coalesce(sum(isu_med_total_na), 0) as isu_med_total_na,
                   coalesce(sum(isu_med_total_no_cumple), 0) as isu_med_total_no_cumple,
                   coalesce(sum(isu_med_total_no_verificado), 0) as isu_med_total_no_verificado,
                   coalesce(sum(isu_ppr_total_preguntas), 0) as isu_ppr_total_preguntas,
                   coalesce(sum(isu_ppr_total_cumple), 0) as isu_ppr_total_cumple,
                   coalesce(sum(isu_ppr_total_cumple_na), 0) as isu_ppr_total_cumple_na,
                   coalesce(sum(isu_ppr_total_na), 0) as isu_ppr_total_na,
                   coalesce(sum(isu_ppr_total_no_cumple), 0) as isu_ppr_total_no_cumple,
                   coalesce(sum(isu_ppr_total_no_verificado), 0) as isu_ppr_total_no_verificado,
                   coalesce(sum(isu_hcl_total_preguntas), 0) as isu_hcl_total_preguntas,
                   coalesce(sum(isu_hcl_total_cumple), 0) as isu_hcl_total_cumple,
                   coalesce(sum(isu_hcl_total_cumple_na), 0) as isu_hcl_total_cumple_na,
                   coalesce(sum(isu_hcl_total_na), 0) as isu_hcl_total_na,
                   coalesce(sum(isu_hcl_total_no_cumple), 0) as isu_hcl_total_no_cumple,
                   coalesce(sum(isu_hcl_total_no_verificado), 0) as isu_hcl_total_no_verificado,
                   coalesce(sum(isu_ind_total_preguntas), 0) as isu_ind_total_preguntas,
                   coalesce(sum(isu_ind_total_cumple), 0) as isu_ind_total_cumple,
                   coalesce(sum(isu_ind_total_cumple_na), 0) as isu_ind_total_cumple_na,
                   coalesce(sum(isu_ind_total_na), 0) as isu_ind_total_na,
                   coalesce(sum(isu_ind_total_no_cumple), 0) as isu_ind_total_no_cumple,
                   coalesce(sum(isu_ind_total_no_verificado), 0) as isu_ind_total_no_verificado,

                   coalesce(sum(isu_total_cumple_na) / nullif(cast(sum(isu_total_preguntas) as float), 0), 0) * 100 as isu_prc_cumplimiento,

                   coalesce(sum(isu_thu_total_cumple) / nullif(cast(sum(isu_thu_total_preguntas) as float), 0), 0) * 100 as isu_thu_prc_cumple,
                   coalesce(sum(isu_thu_total_no_cumple) / nullif(cast(sum(isu_thu_total_preguntas) as float), 0), 0) * 100 as isu_thu_prc_no_cumple,
                   coalesce(sum(isu_thu_total_na) / nullif(cast(sum(isu_thu_total_preguntas) as float), 0), 0) * 100 as isu_thu_prc_na,
                   coalesce(sum(isu_thu_total_no_verificado) / nullif(cast(sum(isu_thu_total_preguntas) as float), 0), 0) * 100 as isu_thu_prc_no_verificado,
                   coalesce(sum(isu_inf_total_cumple) / nullif(cast(sum(isu_inf_total_preguntas) as float), 0), 0) * 100 as isu_inf_prc_cumple,
                   coalesce(sum(isu_inf_total_no_cumple) / nullif(cast(sum(isu_inf_total_preguntas) as float), 0), 0) * 100 as isu_inf_prc_no_cumple,
                   coalesce(sum(isu_inf_total_na) / nullif(cast(sum(isu_inf_total_preguntas) as float), 0), 0) * 100 as isu_inf_prc_na,
                   coalesce(sum(isu_inf_total_no_verificado) / nullif(cast(sum(isu_inf_total_preguntas) as float), 0), 0) * 100 as isu_inf_prc_no_verificado,
                   coalesce(sum(isu_dot_total_cumple) / nullif(cast(sum(isu_dot_total_preguntas) as float), 0), 0) * 100 as isu_dot_prc_cumple,
                   coalesce(sum(isu_dot_total_no_cumple) / nullif(cast(sum(isu_dot_total_preguntas) as float), 0), 0) * 100 as isu_dot_prc_no_cumple,
                   coalesce(sum(isu_dot_total_na) / nullif(cast(sum(isu_dot_total_preguntas) as float), 0), 0) * 100 as isu_dot_prc_na,
                   coalesce(sum(isu_dot_total_no_verificado) / nullif(cast(sum(isu_dot_total_preguntas) as float), 0), 0) * 100 as isu_dot_prc_no_verificado,
                   coalesce(sum(isu_med_total_cumple) / nullif(cast(sum(isu_med_total_preguntas) as float), 0), 0) * 100 as isu_med_prc_cumple,
                   coalesce(sum(isu_med_total_no_cumple) / nullif(cast(sum(isu_med_total_preguntas) as float), 0), 0) * 100 as isu_med_prc_no_cumple,
                   coalesce(sum(isu_med_total_na) / nullif(cast(sum(isu_med_total_preguntas) as float), 0), 0) * 100 as isu_med_prc_na,
                   coalesce(sum(isu_med_total_no_verificado) / nullif(cast(sum(isu_med_total_preguntas) as float), 0), 0) * 100 as isu_med_prc_no_verificado,
                   coalesce(sum(isu_ppr_total_cumple) / nullif(cast(sum(isu_ppr_total_preguntas) as float), 0), 0) * 100 as isu_ppr_prc_cumple,
                   coalesce(sum(isu_ppr_total_no_cumple) / nullif(cast(sum(isu_ppr_total_preguntas) as float), 0), 0) * 100 as isu_ppr_prc_no_cumple,
                   coalesce(sum(isu_ppr_total_na) / nullif(cast(sum(isu_ppr_total_preguntas) as float), 0), 0) * 100 as isu_ppr_prc_na,
                   coalesce(sum(isu_ppr_total_no_verificado) / nullif(cast(sum(isu_ppr_total_preguntas) as float), 0), 0) * 100 as isu_ppr_prc_no_verificado,
                   coalesce(sum(isu_hcl_total_cumple) / nullif(cast(sum(isu_hcl_total_preguntas) as float), 0), 0) * 100 as isu_hcl_prc_cumple,
                   coalesce(sum(isu_hcl_total_no_cumple) / nullif(cast(sum(isu_hcl_total_preguntas) as float), 0), 0) * 100 as isu_hcl_prc_no_cumple,
                   coalesce(sum(isu_hcl_total_na) / nullif(cast(sum(isu_hcl_total_preguntas) as float), 0), 0) * 100 as isu_hcl_prc_na,
                   coalesce(sum(isu_hcl_total_no_verificado) / nullif(cast(sum(isu_hcl_total_preguntas) as float), 0), 0) * 100 as isu_hcl_prc_no_verificado,
                   coalesce(sum(isu_ind_total_cumple) / nullif(cast(sum(isu_ind_total_preguntas) as float), 0), 0) * 100 as isu_ind_prc_cumple,
                   coalesce(sum(isu_ind_total_no_cumple) / nullif(cast(sum(isu_ind_total_preguntas) as float), 0), 0) * 100 as isu_ind_prc_no_cumple,
                   coalesce(sum(isu_ind_total_na) / nullif(cast(sum(isu_ind_total_preguntas) as float), 0), 0) * 100 as isu_ind_prc_na,
                   coalesce(sum(isu_ind_total_no_verificado) / nullif(cast(sum(isu_ind_total_preguntas) as float), 0), 0) * 100 as isu_ind_prc_no_verificado
            from \"".$this->cliente."\".indicadores_suh_3100
            where ".$where
        , $parametros);
    }

    public function actualizarIndicadores(Request $request) {
        DB::connection($this->cliente)->transaction(function() use($request) {
            $ano = $request->ano;
            $mes = $request->mes;

            DB::connection($this->cliente)->statement("
                delete from \"".$this->cliente."\".indicadores_suh_3100
                where isu_ano = ? and isu_mes = ?
            ", [$ano, $mes]);

            $this->actualizarIndicadoresGenerales($ano, $mes);
            $this->actualizarIndicadoresPorServicio($ano, $mes);

            $this->actualizarFechaConsolidacion($ano, $mes);
        });
    }

    public function actualizarIndicadoresGenerales($ano, $mes) {
        $dimensiones = array('mun_fk_id', 'rpr_fk_id', 'rps_fk_id', 'plv_pk_id');

        $indicadores = "
            count(*) as visitas_programadas,
            count(*) filter(where plv_realizada = false) as visitas_por_realizar,
            count(*) filter(where plv_realizada = true) as visitas_realizadas,
            count(*) filter(where esv_fk_id = 1) as visitas_efectivas,
            count(*) filter(where esv_fk_id = 2) as visitas_no_efectivas,
            coalesce(sum(plv_total_preguntas) filter(where plv_realizada = true), 0) as total_criterios,
            coalesce(sum(plv_total_cumple) filter(where plv_realizada = true), 0) as total_criterios_cumplen,
            coalesce(sum(plv_total_cumple_na) filter(where plv_realizada = true), 0) as total_criterios_cumplen_na,
            coalesce(sum(plv_total_na) filter(where plv_realizada = true), 0) as total_criterios_no_aplica,
            coalesce(sum(plv_total_no_cumple) filter(where plv_realizada = true), 0) as total_criterios_no_cumplen,
            coalesce(sum(plv_total_no_verificado) filter(where plv_realizada = true), 0) as total_criterios_no_verificado,
            coalesce(sum(plv_thu_total_preguntas) filter(where plv_realizada = true), 0) as thu_total_criterios,
            coalesce(sum(plv_thu_total_cumple) filter(where plv_realizada = true), 0) as thu_total_criterios_cumplen,
            coalesce(sum(plv_thu_total_cumple_na) filter(where plv_realizada = true), 0) as thu_total_criterios_cumplen_na,
            coalesce(sum(plv_thu_total_na) filter(where plv_realizada = true), 0) as thu_total_criterios_no_aplica,
            coalesce(sum(plv_thu_total_no_cumple) filter(where plv_realizada = true), 0) as thu_total_criterios_no_cumplen,
            coalesce(sum(plv_thu_total_no_verificado) filter(where plv_realizada = true), 0) as thu_total_criterios_no_verificado,
            coalesce(sum(plv_inf_total_preguntas) filter(where plv_realizada = true), 0) as inf_total_criterios,
            coalesce(sum(plv_inf_total_cumple) filter(where plv_realizada = true), 0) as inf_total_criterios_cumplen,
            coalesce(sum(plv_inf_total_cumple_na) filter(where plv_realizada = true), 0) as inf_total_criterios_cumplen_na,
            coalesce(sum(plv_inf_total_na) filter(where plv_realizada = true), 0) as inf_total_criterios_no_aplica,
            coalesce(sum(plv_inf_total_no_cumple) filter(where plv_realizada = true), 0) as inf_total_criterios_no_cumplen,
            coalesce(sum(plv_inf_total_no_verificado) filter(where plv_realizada = true), 0) as inf_total_criterios_no_verificado,
            coalesce(sum(plv_dot_total_preguntas) filter(where plv_realizada = true), 0) as dot_total_criterios,
            coalesce(sum(plv_dot_total_cumple) filter(where plv_realizada = true), 0) as dot_total_criterios_cumplen,
            coalesce(sum(plv_dot_total_cumple_na) filter(where plv_realizada = true), 0) as dot_total_criterios_cumplen_na,
            coalesce(sum(plv_dot_total_na) filter(where plv_realizada = true), 0) as dot_total_criterios_no_aplica,
            coalesce(sum(plv_dot_total_no_cumple) filter(where plv_realizada = true), 0) as dot_total_criterios_no_cumplen,
            coalesce(sum(plv_dot_total_no_verificado) filter(where plv_realizada = true), 0) as dot_total_criterios_no_verificado,
            coalesce(sum(plv_med_total_preguntas) filter(where plv_realizada = true), 0) as med_total_criterios,
            coalesce(sum(plv_med_total_cumple) filter(where plv_realizada = true), 0) as med_total_criterios_cumplen,
            coalesce(sum(plv_med_total_cumple_na) filter(where plv_realizada = true), 0) as med_total_criterios_cumplen_na,
            coalesce(sum(plv_med_total_na) filter(where plv_realizada = true), 0) as med_total_criterios_no_aplica,
            coalesce(sum(plv_med_total_no_cumple) filter(where plv_realizada = true), 0) as med_total_criterios_no_cumplen,
            coalesce(sum(plv_med_total_no_verificado) filter(where plv_realizada = true), 0) as med_total_criterios_no_verificado,
            coalesce(sum(plv_ppr_total_preguntas) filter(where plv_realizada = true), 0) as ppr_total_criterios,
            coalesce(sum(plv_ppr_total_cumple) filter(where plv_realizada = true), 0) as ppr_total_criterios_cumplen,
            coalesce(sum(plv_ppr_total_cumple_na) filter(where plv_realizada = true), 0) as ppr_total_criterios_cumplen_na,
            coalesce(sum(plv_ppr_total_na) filter(where plv_realizada = true), 0) as ppr_total_criterios_no_aplica,
            coalesce(sum(plv_ppr_total_no_cumple) filter(where plv_realizada = true), 0) as ppr_total_criterios_no_cumplen,
            coalesce(sum(plv_ppr_total_no_verificado) filter(where plv_realizada = true), 0) as ppr_total_criterios_no_verificado,
            coalesce(sum(plv_hcl_total_preguntas) filter(where plv_realizada = true), 0) as hcl_total_criterios,
            coalesce(sum(plv_hcl_total_cumple) filter(where plv_realizada = true), 0) as hcl_total_criterios_cumplen,
            coalesce(sum(plv_hcl_total_cumple_na) filter(where plv_realizada = true), 0) as hcl_total_criterios_cumplen_na,
            coalesce(sum(plv_hcl_total_na) filter(where plv_realizada = true), 0) as hcl_total_criterios_no_aplica,
            coalesce(sum(plv_hcl_total_no_cumple) filter(where plv_realizada = true), 0) as hcl_total_criterios_no_cumplen,
            coalesce(sum(plv_hcl_total_no_verificado) filter(where plv_realizada = true), 0) as hcl_total_criterios_no_verificado,
            coalesce(sum(plv_ind_total_preguntas) filter(where plv_realizada = true), 0) as ind_total_criterios,
            coalesce(sum(plv_ind_total_cumple) filter(where plv_realizada = true), 0) as ind_total_criterios_cumplen,
            coalesce(sum(plv_ind_total_cumple_na) filter(where plv_realizada = true), 0) as ind_total_criterios_cumplen_na,
            coalesce(sum(plv_ind_total_na) filter(where plv_realizada = true), 0) as ind_total_criterios_no_aplica,
            coalesce(sum(plv_ind_total_no_cumple) filter(where plv_realizada = true), 0) as ind_total_criterios_no_cumplen,
            coalesce(sum(plv_ind_total_no_verificado) filter(where plv_realizada = true), 0) as ind_total_criterios_no_verificado
        ";

        $querySinDimensiones = "
            insert into \"".$this->cliente."\".indicadores_suh_3100 (
                isu_ano, isu_mes, mun_fk_id, rpr_fk_id, rps_fk_id, srv_codigo_servicio, plv_fk_id, isu_visitas_programadas, isu_visitas_por_realizar,
                isu_visitas_realizadas, isu_visitas_efectivas, isu_visitas_no_efectivas, isu_total_preguntas, isu_total_cumple, isu_total_cumple_na,
                isu_total_na, isu_total_no_cumple, isu_total_no_verificado, isu_thu_total_preguntas, isu_thu_total_cumple, isu_thu_total_cumple_na,
                isu_thu_total_na, isu_thu_total_no_cumple, isu_thu_total_no_verificado, isu_inf_total_preguntas, isu_inf_total_cumple, isu_inf_total_cumple_na,
                isu_inf_total_na, isu_inf_total_no_cumple, isu_inf_total_no_verificado, isu_dot_total_preguntas, isu_dot_total_cumple, isu_dot_total_cumple_na,
                isu_dot_total_na, isu_dot_total_no_cumple, isu_dot_total_no_verificado, isu_med_total_preguntas, isu_med_total_cumple, isu_med_total_cumple_na,
                isu_med_total_na, isu_med_total_no_cumple, isu_med_total_no_verificado, isu_ppr_total_preguntas, isu_ppr_total_cumple, isu_ppr_total_cumple_na,
                isu_ppr_total_na, isu_ppr_total_no_cumple, isu_ppr_total_no_verificado, isu_hcl_total_preguntas, isu_hcl_total_cumple, isu_hcl_total_cumple_na,
                isu_hcl_total_na, isu_hcl_total_no_cumple, isu_hcl_total_no_verificado, isu_ind_total_preguntas, isu_ind_total_cumple, isu_ind_total_cumple_na,
                isu_ind_total_na, isu_ind_total_no_cumple, isu_ind_total_no_verificado
            )
            select ?::smallint, ?::smallint, -1, -1, -1, -1, -1,
                   @indicadores@
            from \"".$this->cliente."\".plan_visitas_suh_3100
            where plv_eliminada = false and plv_ano = ? and plv_mes = ?
        ";

        $queryBase = "
                insert into \"".$this->cliente."\".indicadores_suh_3100 (
                    isu_ano, isu_mes, mun_fk_id, rpr_fk_id, rps_fk_id, srv_codigo_servicio, plv_fk_id, isu_visitas_programadas, isu_visitas_por_realizar,
                    isu_visitas_realizadas, isu_visitas_efectivas, isu_visitas_no_efectivas, isu_total_preguntas, isu_total_cumple, isu_total_cumple_na,
                    isu_total_na, isu_total_no_cumple, isu_total_no_verificado, isu_thu_total_preguntas, isu_thu_total_cumple, isu_thu_total_cumple_na,
                    isu_thu_total_na, isu_thu_total_no_cumple, isu_thu_total_no_verificado, isu_inf_total_preguntas, isu_inf_total_cumple, isu_inf_total_cumple_na,
                    isu_inf_total_na, isu_inf_total_no_cumple, isu_inf_total_no_verificado, isu_dot_total_preguntas, isu_dot_total_cumple, isu_dot_total_cumple_na,
                    isu_dot_total_na, isu_dot_total_no_cumple, isu_dot_total_no_verificado, isu_med_total_preguntas, isu_med_total_cumple, isu_med_total_cumple_na,
                    isu_med_total_na, isu_med_total_no_cumple, isu_med_total_no_verificado, isu_ppr_total_preguntas, isu_ppr_total_cumple, isu_ppr_total_cumple_na,
                    isu_ppr_total_na, isu_ppr_total_no_cumple, isu_ppr_total_no_verificado, isu_hcl_total_preguntas, isu_hcl_total_cumple, isu_hcl_total_cumple_na,
                    isu_hcl_total_na, isu_hcl_total_no_cumple, isu_hcl_total_no_verificado, isu_ind_total_preguntas, isu_ind_total_cumple, isu_ind_total_cumple_na,
                    isu_ind_total_na, isu_ind_total_no_cumple, isu_ind_total_no_verificado
                )
                select ?::smallint,
                       ?::smallint,
                       @dimensiones@
                       @indicadores@
                from \"".$this->cliente."\".plan_visitas_suh_3100 as plv
                @join@
                where plv_eliminada = false and plv_ano = ? and plv_mes = ?
                group by 1,2,3,4,5,6,7
        ";

        // Ejecutar el query sin dimensiones
        $querySDModificado = str_replace("@indicadores@", trim($indicadores), $querySinDimensiones);
        DB::connection($this->cliente)->statement($querySDModificado, [$ano, $mes, $ano, $mes]);

        // Ejecutar el query con dimensiones
        foreach ($dimensiones as $dim) {
            $dimensionesProcesadas = "";
            $joinProcesados = "";

            if ($dim === "mun_fk_id") {
                $dimensionesProcesadas = "rps.mun_fk_id, -1, -1, -1, -1,";
                $joinProcesados = "join base.reps_prestadores_sedes as rps on (rps_pk_id = rps_fk_id)";
            } else if ($dim === "rpr_fk_id") {
                $dimensionesProcesadas = "-1, rps.rpr_fk_id, -1, -1, -1,";
                $joinProcesados = "join base.reps_prestadores_sedes as rps on (rps_pk_id = rps_fk_id)";
            } else if ($dim === "rps_fk_id") {
                $dimensionesProcesadas = "-1, rps.rpr_fk_id, rps_fk_id, -1, -1,";
                $joinProcesados = "join base.reps_prestadores_sedes as rps on (rps_pk_id = rps_fk_id)";
            } else if ($dim === "plv_pk_id") {
                $dimensionesProcesadas = "-1, -1, -1, -1, plv_pk_id,";
            }

            $queryBaseModificado = str_replace("@dimensiones@", trim($dimensionesProcesadas), $queryBase);
            $queryBaseModificado = str_replace("@join@", trim($joinProcesados), $queryBaseModificado);
            $queryBaseModificado = str_replace("@indicadores@", trim($indicadores), $queryBaseModificado);

            DB::connection($this->cliente)->statement($queryBaseModificado, [$ano, $mes, $ano, $mes]);
        }
    }

    public function actualizarIndicadoresPorServicio($ano, $mes) {
        $dimensiones = array('mun_fk_id', 'rpr_fk_id', 'rps_fk_id', 'plv_fk_id');

        $indicadores = "
            count(*) as visitas_programadas,
            count(*) filter(where plv_realizada = false) as visitas_por_realizar,
            count(*) filter(where plv_realizada = true) as visitas_realizadas,
            count(*) filter(where esv_fk_id = 1) as visitas_efectivas,
            count(*) filter(where esv_fk_id = 2) as visitas_no_efectivas,
            coalesce(sum(ais_total_preguntas) filter(where plv_realizada = true), 0) as total_criterios,
            coalesce(sum(ais_total_cumple) filter(where plv_realizada = true), 0) as total_criterios_cumplen,
            coalesce(sum(ais_total_cumple_na) filter(where plv_realizada = true), 0) as total_criterios_cumplen_na,
            coalesce(sum(ais_total_na) filter(where plv_realizada = true), 0) as total_criterios_no_aplica,
            coalesce(sum(ais_total_no_cumple) filter(where plv_realizada = true), 0) as total_criterios_no_cumplen,
            coalesce(sum(ais_total_no_verificado) filter(where plv_realizada = true), 0) as total_criterios_no_verificado,
            coalesce(sum(ais_thu_total_preguntas) filter(where plv_realizada = true), 0) as thu_total_criterios,
            coalesce(sum(ais_thu_total_cumple) filter(where plv_realizada = true), 0) as thu_total_criterios_cumplen,
            coalesce(sum(ais_thu_total_cumple_na) filter(where plv_realizada = true), 0) as thu_total_criterios_cumplen_na,
            coalesce(sum(ais_thu_total_na) filter(where plv_realizada = true), 0) as thu_total_criterios_no_aplica,
            coalesce(sum(ais_thu_total_no_cumple) filter(where plv_realizada = true), 0) as thu_total_criterios_no_cumplen,
            coalesce(sum(ais_thu_total_no_verificado) filter(where plv_realizada = true), 0) as thu_total_criterios_no_verificado,
            coalesce(sum(ais_inf_total_preguntas) filter(where plv_realizada = true), 0) as inf_total_criterios,
            coalesce(sum(ais_inf_total_cumple) filter(where plv_realizada = true), 0) as inf_total_criterios_cumplen,
            coalesce(sum(ais_inf_total_cumple_na) filter(where plv_realizada = true), 0) as inf_total_criterios_cumplen_na,
            coalesce(sum(ais_inf_total_na) filter(where plv_realizada = true), 0) as inf_total_criterios_no_aplica,
            coalesce(sum(ais_inf_total_no_cumple) filter(where plv_realizada = true), 0) as inf_total_criterios_no_cumplen,
            coalesce(sum(ais_inf_total_no_verificado) filter(where plv_realizada = true), 0) as inf_total_criterios_no_verificado,
            coalesce(sum(ais_dot_total_preguntas) filter(where plv_realizada = true), 0) as dot_total_criterios,
            coalesce(sum(ais_dot_total_cumple) filter(where plv_realizada = true), 0) as dot_total_criterios_cumplen,
            coalesce(sum(ais_dot_total_cumple_na) filter(where plv_realizada = true), 0) as dot_total_criterios_cumplen_na,
            coalesce(sum(ais_dot_total_na) filter(where plv_realizada = true), 0) as dot_total_criterios_no_aplica,
            coalesce(sum(ais_dot_total_no_cumple) filter(where plv_realizada = true), 0) as dot_total_criterios_no_cumplen,
            coalesce(sum(ais_dot_total_no_verificado) filter(where plv_realizada = true), 0) as dot_total_criterios_no_verificado,
            coalesce(sum(ais_med_total_preguntas) filter(where plv_realizada = true), 0) as med_total_criterios,
            coalesce(sum(ais_med_total_cumple) filter(where plv_realizada = true), 0) as med_total_criterios_cumplen,
            coalesce(sum(ais_med_total_cumple_na) filter(where plv_realizada = true), 0) as med_total_criterios_cumplen_na,
            coalesce(sum(ais_med_total_na) filter(where plv_realizada = true), 0) as med_total_criterios_no_aplica,
            coalesce(sum(ais_med_total_no_cumple) filter(where plv_realizada = true), 0) as med_total_criterios_no_cumplen,
            coalesce(sum(ais_med_total_no_verificado) filter(where plv_realizada = true), 0) as med_total_criterios_no_verificado,
            coalesce(sum(ais_ppr_total_preguntas) filter(where plv_realizada = true), 0) as ppr_total_criterios,
            coalesce(sum(ais_ppr_total_cumple) filter(where plv_realizada = true), 0) as ppr_total_criterios_cumplen,
            coalesce(sum(ais_ppr_total_cumple_na) filter(where plv_realizada = true), 0) as ppr_total_criterios_cumplen_na,
            coalesce(sum(ais_ppr_total_na) filter(where plv_realizada = true), 0) as ppr_total_criterios_no_aplica,
            coalesce(sum(ais_ppr_total_no_cumple) filter(where plv_realizada = true), 0) as ppr_total_criterios_no_cumplen,
            coalesce(sum(ais_ppr_total_no_verificado) filter(where plv_realizada = true), 0) as ppr_total_criterios_no_verificado,
            coalesce(sum(ais_hcl_total_preguntas) filter(where plv_realizada = true), 0) as hcl_total_criterios,
            coalesce(sum(ais_hcl_total_cumple) filter(where plv_realizada = true), 0) as hcl_total_criterios_cumplen,
            coalesce(sum(ais_hcl_total_cumple_na) filter(where plv_realizada = true), 0) as hcl_total_criterios_cumplen_na,
            coalesce(sum(ais_hcl_total_na) filter(where plv_realizada = true), 0) as hcl_total_criterios_no_aplica,
            coalesce(sum(ais_hcl_total_no_cumple) filter(where plv_realizada = true), 0) as hcl_total_criterios_no_cumplen,
            coalesce(sum(ais_hcl_total_no_verificado) filter(where plv_realizada = true), 0) as hcl_total_criterios_no_verificado,
            coalesce(sum(ais_ind_total_preguntas) filter(where plv_realizada = true), 0) as ind_total_criterios,
            coalesce(sum(ais_ind_total_cumple) filter(where plv_realizada = true), 0) as ind_total_criterios_cumplen,
            coalesce(sum(ais_ind_total_cumple_na) filter(where plv_realizada = true), 0) as ind_total_criterios_cumplen_na,
            coalesce(sum(ais_ind_total_na) filter(where plv_realizada = true), 0) as ind_total_criterios_no_aplica,
            coalesce(sum(ais_ind_total_no_cumple) filter(where plv_realizada = true), 0) as ind_total_criterios_no_cumplen,
            coalesce(sum(ais_ind_total_no_verificado) filter(where plv_realizada = true), 0) as ind_total_criterios_no_verificado
        ";

        $querySinDimensiones = "
            insert into \"".$this->cliente."\".indicadores_suh_3100 (
                isu_ano, isu_mes, mun_fk_id, rpr_fk_id, rps_fk_id, srv_codigo_servicio, plv_fk_id, isu_visitas_programadas, isu_visitas_por_realizar,
                isu_visitas_realizadas, isu_visitas_efectivas, isu_visitas_no_efectivas, isu_total_preguntas, isu_total_cumple, isu_total_cumple_na,
                isu_total_na, isu_total_no_cumple, isu_total_no_verificado, isu_thu_total_preguntas, isu_thu_total_cumple, isu_thu_total_cumple_na,
                isu_thu_total_na, isu_thu_total_no_cumple, isu_thu_total_no_verificado, isu_inf_total_preguntas, isu_inf_total_cumple, isu_inf_total_cumple_na,
                isu_inf_total_na, isu_inf_total_no_cumple, isu_inf_total_no_verificado, isu_dot_total_preguntas, isu_dot_total_cumple, isu_dot_total_cumple_na,
                isu_dot_total_na, isu_dot_total_no_cumple, isu_dot_total_no_verificado, isu_med_total_preguntas, isu_med_total_cumple, isu_med_total_cumple_na,
                isu_med_total_na, isu_med_total_no_cumple, isu_med_total_no_verificado, isu_ppr_total_preguntas, isu_ppr_total_cumple, isu_ppr_total_cumple_na,
                isu_ppr_total_na, isu_ppr_total_no_cumple, isu_ppr_total_no_verificado, isu_hcl_total_preguntas, isu_hcl_total_cumple, isu_hcl_total_cumple_na,
                isu_hcl_total_na, isu_hcl_total_no_cumple, isu_hcl_total_no_verificado, isu_ind_total_preguntas, isu_ind_total_cumple, isu_ind_total_cumple_na,
                isu_ind_total_na, isu_ind_total_no_cumple, isu_ind_total_no_verificado
            )
            select ?::smallint, ?::smallint, -1, -1, -1, svs_codigo_servicio, -1,
                   @indicadores@
            from \"".$this->cliente."\".auxiliar_indicadores_visitas_suh_3100 as ais
            join \"".$this->cliente."\".plan_visitas_suh_3100 as plv on ais.plv_fk_id = plv.plv_pk_id
            join \"".$this->cliente."\".servicios_visitas_suh_3100 as svs on ais.svs_fk_id = svs.svs_pk_id
            where ais_ano = ? and ais_mes = ? and plv_eliminada = false
            group by 1, 2, 3, 4, 5, 6, 7
        ";

        $queryBase = "
                insert into \"".$this->cliente."\".indicadores_suh_3100 (
                    isu_ano, isu_mes, mun_fk_id, rpr_fk_id, rps_fk_id, srv_codigo_servicio, plv_fk_id, isu_visitas_programadas, isu_visitas_por_realizar,
                    isu_visitas_realizadas, isu_visitas_efectivas, isu_visitas_no_efectivas, isu_total_preguntas, isu_total_cumple, isu_total_cumple_na,
                    isu_total_na, isu_total_no_cumple, isu_total_no_verificado, isu_thu_total_preguntas, isu_thu_total_cumple, isu_thu_total_cumple_na,
                    isu_thu_total_na, isu_thu_total_no_cumple, isu_thu_total_no_verificado, isu_inf_total_preguntas, isu_inf_total_cumple, isu_inf_total_cumple_na,
                    isu_inf_total_na, isu_inf_total_no_cumple, isu_inf_total_no_verificado, isu_dot_total_preguntas, isu_dot_total_cumple, isu_dot_total_cumple_na,
                    isu_dot_total_na, isu_dot_total_no_cumple, isu_dot_total_no_verificado, isu_med_total_preguntas, isu_med_total_cumple, isu_med_total_cumple_na,
                    isu_med_total_na, isu_med_total_no_cumple, isu_med_total_no_verificado, isu_ppr_total_preguntas, isu_ppr_total_cumple, isu_ppr_total_cumple_na,
                    isu_ppr_total_na, isu_ppr_total_no_cumple, isu_ppr_total_no_verificado, isu_hcl_total_preguntas, isu_hcl_total_cumple, isu_hcl_total_cumple_na,
                    isu_hcl_total_na, isu_hcl_total_no_cumple, isu_hcl_total_no_verificado, isu_ind_total_preguntas, isu_ind_total_cumple, isu_ind_total_cumple_na,
                    isu_ind_total_na, isu_ind_total_no_cumple, isu_ind_total_no_verificado
                )
                select ?::smallint,
                       ?::smallint,
                       @dimensiones@
                       @indicadores@
                from \"".$this->cliente."\".auxiliar_indicadores_visitas_suh_3100 as ais
                join \"".$this->cliente."\".plan_visitas_suh_3100 as plv on ais.plv_fk_id = plv.plv_pk_id
                join \"".$this->cliente."\".servicios_visitas_suh_3100 as svs on ais.svs_fk_id = svs.svs_pk_id
                @join@
                where ais_ano = ? and ais_mes = ? and plv_eliminada = false
                group by 1,2,3,4,5,6,7
        ";

        // Ejecutar el query sin dimensiones
        $querySDModificado = str_replace("@indicadores@", trim($indicadores), $querySinDimensiones);
        DB::connection($this->cliente)->statement($querySDModificado, [$ano, $mes, $ano, $mes]);

        // Ejecutar el query con dimensiones
        foreach ($dimensiones as $dim) {
            $dimensionesProcesadas = "";
            $joinProcesados = "";

            if ($dim === "mun_fk_id") {
                $dimensionesProcesadas = "rps.mun_fk_id, -1, -1, svs_codigo_servicio, -1,";
                $joinProcesados = "join base.reps_prestadores_sedes as rps on (rps_pk_id = rps_fk_id)";
            } else if ($dim === "rpr_fk_id") {
                $dimensionesProcesadas = "-1, rps.rpr_fk_id, -1, svs_codigo_servicio, -1,";
                $joinProcesados = "join base.reps_prestadores_sedes as rps on (rps_pk_id = rps_fk_id)";
            } else if ($dim === "rps_fk_id") {
                $dimensionesProcesadas = "-1, rps.rpr_fk_id, rps_fk_id, svs_codigo_servicio, -1,";
                $joinProcesados = "join base.reps_prestadores_sedes as rps on (rps_pk_id = rps_fk_id)";
            } else if ($dim === "plv_fk_id") {
                $dimensionesProcesadas = "-1, -1, -1, svs_codigo_servicio, ais.plv_fk_id,";
            }

            $queryBaseModificado = str_replace("@dimensiones@", trim($dimensionesProcesadas), $queryBase);
            $queryBaseModificado = str_replace("@join@", trim($joinProcesados), $queryBaseModificado);
            $queryBaseModificado = str_replace("@indicadores@", trim($indicadores), $queryBaseModificado);

            DB::connection($this->cliente)->statement($queryBaseModificado, [$ano, $mes, $ano, $mes]);
        }
    }

    private function actualizarFechaConsolidacion($ano, $mes) {
        $registro = EstadoConsolidacionIndicadores::on($this->cliente)
                                                  ->where('eci_ano', $ano)
                                                  ->where('eci_mes', $mes)
                                                  ->get()->toArray();

        if (count($registro) > 0) {
            EstadoConsolidacionIndicadores::on($this->cliente)->where('eci_pk_id', $registro[0]['eci_pk_id'])->update([
                'eci_suh_3100' => 'now()'
            ]);
        } else {
            EstadoConsolidacionIndicadores::on($this->cliente)->create([
                'eci_ano' => $ano,
                'eci_mes' => $mes,
                'eci_suh_3100' => 'now()'
            ]);
        }
    }
}
