<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasPyMAdultezHombres;
use App\Models\clientes\HistoricoInsRiasPyMAdultezHombres;

class InstrumentosRiasPyMAdultezHombresController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasPyMAdultezHombres::on($this->cliente)
                                                ->orderBy('ird_activa', 'desc')
                                                ->orderBy('ird_pk_id', 'desc')
                                                ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_pym_adultez_hombres\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasPyMAdultezHombres::on($this->cliente)->create([
                'ird_version' => $nuevaVersion,
                'ird_comentarios' => $request->ird_comentarios,
                'ird_instrumento' => json_encode($request->ird_instrumento),
                'ird_usu_creacion' => $usuario
            ])->ird_pk_id;

            HistoricoInsRiasPyMAdultezHombres::on($this->cliente)->create([
                'ird_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrd_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasPyMAdultezHombres::on($this->cliente)->where('ird_pk_id', $id)->update([
                'ird_comentarios' => $request->ird_comentarios,
                'ird_instrumento' => $request->ird_instrumento
            ]);

            HistoricoInsRiasPyMAdultezHombres::on($this->cliente)->create([
                'ird_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrd_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasPyMAdultezHombres::on($this->cliente)
                                                        ->where('ird_activa', true)
                                                        ->pluck('ird_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasPyMAdultezHombres::on($this->cliente)->where('ird_pk_id', $idActivo)->update([
                'ird_activa' => false
            ]);

            HistoricoInsRiasPyMAdultezHombres::on($this->cliente)->create([
                'ird_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hrd_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasPyMAdultezHombres::on($this->cliente)->where('ird_pk_id', $id)->update([
                'ird_activa' => true
            ]);

            HistoricoInsRiasPyMAdultezHombres::on($this->cliente)->create([
                'ird_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrd_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasPyMAdultezHombres::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_pym_adultez_hombres.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('ird_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
