<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasPyMTransversales;
use App\Models\clientes\HistoricoInsRiasPyMTransversales;

class InstrumentosRiasPyMTransversalesController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasPyMTransversales::on($this->cliente)
                                               ->orderBy('irt_activa', 'desc')
                                               ->orderBy('irt_pk_id', 'desc')
                                               ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_pym_transversales\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasPyMTransversales::on($this->cliente)->create([
                'irt_version' => $nuevaVersion,
                'irt_comentarios' => $request->irt_comentarios,
                'irt_instrumento' => json_encode($request->irt_instrumento),
                'irt_usu_creacion' => $usuario
            ])->irt_pk_id;

            HistoricoInsRiasPyMTransversales::on($this->cliente)->create([
                'irt_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrt_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasPyMTransversales::on($this->cliente)->where('irt_pk_id', $id)->update([
                'irt_comentarios' => $request->irt_comentarios,
                'irt_instrumento' => $request->irt_instrumento
            ]);

            HistoricoInsRiasPyMTransversales::on($this->cliente)->create([
                'irt_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrt_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasPyMTransversales::on($this->cliente)
                                            ->where('irt_activa', true)
                                            ->pluck('irt_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasPyMTransversales::on($this->cliente)->where('irt_pk_id', $idActivo)->update([
                'irt_activa' => false
            ]);

            HistoricoInsRiasPyMTransversales::on($this->cliente)->create([
                'irt_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hrt_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasPyMTransversales::on($this->cliente)->where('irt_pk_id', $id)->update([
                'irt_activa' => true
            ]);

            HistoricoInsRiasPyMTransversales::on($this->cliente)->create([
                'irt_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrt_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasPyMTransversales::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_pym_transversales.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('irt_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
