<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AutorizacionCambioBloqueo extends Mailable
{
    use Queueable, SerializesModels;

    public $ruta;
    public $codigo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($ruta, $codigo)
    {
        $this->ruta = $ruta;
        $this->codigo = $codigo;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('administrador@tguia-iv')
                    ->view('mail.autorizacionCambioBloqueo')
                    ->text('mail.autorizacionCambioBloqueo_plain')
                    ->with(
                        [
                            'route' => $this->ruta,
                            'codigo' => $this->codigo
                        ]
                    );
    }
}
