<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Laravel\Passport\Passport;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        Passport::tokensCan([
            'ver-adm' => 'Peticiones en las rutas del administrador',
            'ver-adm-lid' => 'Peticiones en las rutas del rol administrador / lider',
            'ver-lid' => 'Peticiones en las rutas del rol lider',
            'ver-aud' => 'Peticiones en las rutas del rol auditor/verificador',
            'ver-aud-mob' => 'Peticiones en las rutas del rol auditor/verificador desde la aplicación móvil',
        ]);

        Passport::setDefaultScope([
            'ver-aud'
        ]);
    }
}
