<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Auth\UsuariosController;
use App\Http\Controllers\Auth\ParametrosController;
use App\Http\Controllers\API\MiEntidadController;
use App\Http\Controllers\API\RepsController;

use App\Http\Controllers\API\InstrumentosAudCalidadController;
use App\Http\Controllers\API\InstrumentosAudPamecController;
use App\Http\Controllers\API\InstrumentosAudRiasPyMController;
use App\Http\Controllers\API\InstrumentosAudRiasAPNController;
use App\Http\Controllers\API\InstrumentosRiasPyMTransversalesController;
use App\Http\Controllers\API\InstrumentosRiasPyMPrimInfanciaController;
use App\Http\Controllers\API\InstrumentosRiasPyMInfanciaController;
use App\Http\Controllers\API\InstrumentosRiasPyMAdolescenciaController;
use App\Http\Controllers\API\InstrumentosRiasPyMJuventudController;
use App\Http\Controllers\API\InstrumentosRiasPyMAdultezHombresController;
use App\Http\Controllers\API\InstrumentosRiasPyMAdultezMujeresController;
use App\Http\Controllers\API\InstrumentosRiasPyMVejezHombresController;
use App\Http\Controllers\API\InstrumentosRiasPyMVejezMujeresController;
use App\Http\Controllers\API\InstrumentosRiasAPNAtnPreconcepcionalController;
use App\Http\Controllers\API\InstrumentosRiasAPNIveController;
use App\Http\Controllers\API\InstrumentosRiasAPNCuidadoPrenatalController;
use App\Http\Controllers\API\InstrumentosRiasAPNCursoPreparacionController;
use App\Http\Controllers\API\InstrumentosRiasAPNAtencionPartoController;
use App\Http\Controllers\API\InstrumentosRiasAPNEmerObstetricaController;
use App\Http\Controllers\API\InstrumentosRiasAPNAtnPuerperioController;
use App\Http\Controllers\API\InstrumentosRiasAPNAtencionRNController;
use App\Http\Controllers\API\InstrumentosRiasAPNAtnComplicacionesController;
use App\Http\Controllers\API\InstrumentosRiasAPNSeguimientoRNController;
use App\Http\Controllers\API\InstrumentosRiasAPNAtnFamiliasController;

use App\Http\Controllers\API\PlanVisitasController;
use App\Http\Controllers\API\PlanVisitasCalidadController;

use App\Http\Controllers\API\PlanVisitasPamecController;
use App\Http\Controllers\API\AuditoriaPamecController;
use App\Http\Controllers\API\IndicadoresAuditoriaPamecController;

use App\Http\Controllers\API\PlanVisitasRiasController;

use App\Http\Controllers\API\PlanVisitasSuh3100Controller;
use App\Http\Controllers\API\IndicadoresSuh3100Controller;

use App\Http\Controllers\API\ConsolidacionIndicadoresController;

Route::middleware('urlFilter')->post('/v1/acceso/autenticarUsuario', [UsuariosController::class, 'autenticarUsuario']);
Route::middleware('urlFilter')->post('/v1/acceso/autenticarUsuarioAplicacionMovil', [UsuariosController::class, 'autenticarUsuarioAplicacionMovil']);
Route::middleware('urlFilter')->post('/v1/acceso/verificarCodigoAccesoMovil', [UsuariosController::class, 'verificarCodigoAccesoMovil']);

Route::group(['middleware' => ['auth:api', 'urlFilter'], 'prefix' => 'v1/acceso'], function () {
    Route::delete('cerrarSesion', [UsuariosController::class, 'cerrarSesion']);
});

Route::group(['middleware' => ['auth:api', 'urlFilter'], 'prefix' => 'v1/acceso'], function () {
    Route::get('obtenerRolUsuario', [UsuariosController::class, 'obtenerRolUsuario']);
    Route::post('validarTokenUsuario', [UsuariosController::class, 'validarTokenUsuario']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm,ver-adm-lid', 'urlFilter'], 'prefix' => 'v1/usuarios'], function () {
    Route::get('obtenerUsuariosLicenciados', [UsuariosController::class, 'obtenerUsuariosLicenciados']);
    Route::post('asignarLicenciaUsuario', [UsuariosController::class, 'asignarLicenciaUsuario']);
    Route::put('actualizarLicenciaUsuario/{idUsuario}', [UsuariosController::class, 'actualizarLicenciaUsuario']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/usuarios'], function () {
    Route::get('obtenerUsuariosRegistrados', [UsuariosController::class, 'obtenerUsuariosRegistrados']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm,ver-adm-lid', 'urlFilter'], 'prefix' => 'v1/parametros'], function () {
    Route::get('obtenerModulosHabilitados', [ParametrosController::class, 'obtenerModulosHabilitados']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/usuarios'], function () {
    Route::get('obtenerUsuariosAuditoresVerificadores', [UsuariosController::class, 'obtenerUsuariosAuditoresVerificadores']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm,ver-adm-lid', 'urlFilter'], 'prefix' => 'v1/mi-entidad'], function () {
    Route::get('obtenerIdentificadorLogoEntidad', [MiEntidadController::class, 'obtenerIdentificadorLogoEntidad']);
    Route::post('actualizarLogo', [MiEntidadController::class, 'actualizarLogoEntidad']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid,ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/mi-entidad'], function () {
    Route::get('obtenerLogoEntidad', [MiEntidadController::class, 'obtenerLogoEntidad']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/usuarios'], function () {
    Route::get('obtenerEstadoPlazoCambioCodigo', [UsuariosController::class, 'obtenerEstadoPlazoCambioCodigo']);
    Route::get('enviarAutorizacionCambioCodigo', [UsuariosController::class, 'enviarAutorizacionCambioCodigo']);
    Route::post('actualizarCodigoBloqueo', [UsuariosController::class, 'actualizarCodigoBloqueo']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/reps'], function () {
    Route::get('obtenerPrestadoresDepartamento/{depto}', [RepsController::class, 'obtenerPrestadoresDepartamento']);
    Route::get('obtenerPrestadoresMunicipio/{municipio}', [RepsController::class, 'obtenerPrestadoresMunicipio']);
    Route::get('obtenerSedesPrestador/{idPrestador}', [RepsController::class, 'obtenerSedesPrestador']);
    Route::get('obtenerSedesPrestadorMunicipio/{depto}/{municipio}/{idPrestador}', [RepsController::class, 'obtenerSedesPrestadorMunicipio']);
    Route::get('obtenerServiciosSedeSuh3100/{prestador}/{sede}', [RepsController::class, 'obtenerServiciosSedeSuh3100']);
    Route::get('obtenerServiciosPrestadorSuh3100/{prestador}', [RepsController::class, 'obtenerServiciosPrestadorSuh3100']);
    Route::get('obtenerServiciosSuh3100', [RepsController::class, 'obtenerServiciosSuh3100']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/gestion-instrumentos'], function () {
    Route::get('obtenerInstrumentosAudCalidadConUrgencias', [InstrumentosAudCalidadController::class, 'obtenerInstrumentosConUrgencias']);
    Route::get('obtenerInstrumentosAudCalidadSinUrgencias', [InstrumentosAudCalidadController::class, 'obtenerInstrumentosSinUrgencias']);
    Route::post('crearInstrumentoAudCalidad', [InstrumentosAudCalidadController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoAudCalidad/{id}', [InstrumentosAudCalidadController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoAudCalidad/{id}', [InstrumentosAudCalidadController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionAudCalidad/{id}', [InstrumentosAudCalidadController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosAudPamecConAcreditacion', [InstrumentosAudPamecController::class, 'obtenerInstrumentosConAcreditacion']);
    Route::get('obtenerInstrumentosAudPamecSinAcreditacion', [InstrumentosAudPamecController::class, 'obtenerInstrumentosSinAcreditacion']);
    Route::get('obtenerInstrumentoPorId/{idVersion}', [InstrumentosAudPamecController::class, 'obtenerInstrumentoPorId']);
    Route::post('crearInstrumentoAudPamec', [InstrumentosAudPamecController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoAudPamec/{id}', [InstrumentosAudPamecController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoAudPamec/{id}', [InstrumentosAudPamecController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionAudPamec/{id}', [InstrumentosAudPamecController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMTransversales', [InstrumentosRiasPyMTransversalesController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMTransversales', [InstrumentosRiasPyMTransversalesController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMTransversales/{id}', [InstrumentosRiasPyMTransversalesController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMTransversales/{id}', [InstrumentosRiasPyMTransversalesController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMTransversales/{id}', [InstrumentosRiasPyMTransversalesController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMPrimInfancia', [InstrumentosRiasPyMPrimInfanciaController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMPrimInfancia', [InstrumentosRiasPyMPrimInfanciaController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMPrimInfancia/{id}', [InstrumentosRiasPyMPrimInfanciaController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMPrimInfancia/{id}', [InstrumentosRiasPyMPrimInfanciaController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMPrimInfancia/{id}', [InstrumentosRiasPyMPrimInfanciaController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMInfancia', [InstrumentosRiasPyMInfanciaController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMInfancia', [InstrumentosRiasPyMInfanciaController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMInfancia/{id}', [InstrumentosRiasPyMInfanciaController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMInfancia/{id}', [InstrumentosRiasPyMInfanciaController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMInfancia/{id}', [InstrumentosRiasPyMInfanciaController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMAdolescencia', [InstrumentosRiasPyMAdolescenciaController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMAdolescencia', [InstrumentosRiasPyMAdolescenciaController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMAdolescencia/{id}', [InstrumentosRiasPyMAdolescenciaController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMAdolescencia/{id}', [InstrumentosRiasPyMAdolescenciaController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMAdolescencia/{id}', [InstrumentosRiasPyMAdolescenciaController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMJuventud', [InstrumentosRiasPyMJuventudController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMJuventud', [InstrumentosRiasPyMJuventudController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMJuventud/{id}', [InstrumentosRiasPyMJuventudController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMJuventud/{id}', [InstrumentosRiasPyMJuventudController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMJuventud/{id}', [InstrumentosRiasPyMJuventudController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMAdultezHombres', [InstrumentosRiasPyMAdultezHombresController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMAdultezHombres', [InstrumentosRiasPyMAdultezHombresController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMAdultezHombres/{id}', [InstrumentosRiasPyMAdultezHombresController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMAdultezHombres/{id}', [InstrumentosRiasPyMAdultezHombresController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMAdultezHombres/{id}', [InstrumentosRiasPyMAdultezHombresController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMAdultezMujeres', [InstrumentosRiasPyMAdultezMujeresController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMAdultezMujeres', [InstrumentosRiasPyMAdultezMujeresController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMAdultezMujeres/{id}', [InstrumentosRiasPyMAdultezMujeresController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMAdultezMujeres/{id}', [InstrumentosRiasPyMAdultezMujeresController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMAdultezMujeres/{id}', [InstrumentosRiasPyMAdultezMujeresController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMVejezHombres', [InstrumentosRiasPyMVejezHombresController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMVejezHombres', [InstrumentosRiasPyMVejezHombresController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMVejezHombres/{id}', [InstrumentosRiasPyMVejezHombresController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMVejezHombres/{id}', [InstrumentosRiasPyMVejezHombresController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMVejezHombres/{id}', [InstrumentosRiasPyMVejezHombresController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasPyMVejezMujeres', [InstrumentosRiasPyMVejezMujeresController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasPyMVejezMujeres', [InstrumentosRiasPyMVejezMujeresController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasPyMVejezMujeres/{id}', [InstrumentosRiasPyMVejezMujeresController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasPyMVejezMujeres/{id}', [InstrumentosRiasPyMVejezMujeresController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasPyMVejezMujeres/{id}', [InstrumentosRiasPyMVejezMujeresController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnAtnPreconcepcional', [InstrumentosRiasAPNAtnPreconcepcionalController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnAtnPreconcepcional', [InstrumentosRiasAPNAtnPreconcepcionalController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnAtnPreconcepcional/{id}', [InstrumentosRiasAPNAtnPreconcepcionalController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnAtnPreconcepcional/{id}', [InstrumentosRiasAPNAtnPreconcepcionalController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnAtnPreconcepcional/{id}', [InstrumentosRiasAPNAtnPreconcepcionalController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnIve', [InstrumentosRiasAPNIveController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnIve', [InstrumentosRiasAPNIveController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnIve/{id}', [InstrumentosRiasAPNIveController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnIve/{id}', [InstrumentosRiasAPNIveController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnIve/{id}', [InstrumentosRiasAPNIveController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnCuidadoPrenatal', [InstrumentosRiasAPNCuidadoPrenatalController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnCuidadoPrenatal', [InstrumentosRiasAPNCuidadoPrenatalController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnCuidadoPrenatal/{id}', [InstrumentosRiasAPNCuidadoPrenatalController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnCuidadoPrenatal/{id}', [InstrumentosRiasAPNCuidadoPrenatalController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnCuidadoPrenatal/{id}', [InstrumentosRiasAPNCuidadoPrenatalController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnCursoPreparacion', [InstrumentosRiasAPNCursoPreparacionController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnCursoPreparacion', [InstrumentosRiasAPNCursoPreparacionController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnCursoPreparacion/{id}', [InstrumentosRiasAPNCursoPreparacionController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnCursoPreparacion/{id}', [InstrumentosRiasAPNCursoPreparacionController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnCursoPreparacion/{id}', [InstrumentosRiasAPNCursoPreparacionController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnAtencionParto', [InstrumentosRiasAPNAtencionPartoController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnAtencionParto', [InstrumentosRiasAPNAtencionPartoController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnAtencionParto/{id}', [InstrumentosRiasAPNAtencionPartoController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnAtencionParto/{id}', [InstrumentosRiasAPNAtencionPartoController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnAtencionParto/{id}', [InstrumentosRiasAPNAtencionPartoController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnEmerObstetrica', [InstrumentosRiasAPNEmerObstetricaController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnEmerObstetrica', [InstrumentosRiasAPNEmerObstetricaController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnEmerObstetrica/{id}', [InstrumentosRiasAPNEmerObstetricaController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnEmerObstetrica/{id}', [InstrumentosRiasAPNEmerObstetricaController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnEmerObstetrica/{id}', [InstrumentosRiasAPNEmerObstetricaController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnAtnPuerperio', [InstrumentosRiasAPNAtnPuerperioController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnAtnPuerperio', [InstrumentosRiasAPNAtnPuerperioController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnAtnPuerperio/{id}', [InstrumentosRiasAPNAtnPuerperioController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnAtnPuerperio/{id}', [InstrumentosRiasAPNAtnPuerperioController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnAtnPuerperio/{id}', [InstrumentosRiasAPNAtnPuerperioController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnAtencionRN', [InstrumentosRiasAPNAtencionRNController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnAtencionRN', [InstrumentosRiasAPNAtencionRNController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnAtencionRN/{id}', [InstrumentosRiasAPNAtencionRNController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnAtencionRN/{id}', [InstrumentosRiasAPNAtencionRNController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnAtencionRN/{id}', [InstrumentosRiasAPNAtencionRNController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnAtnComplicaciones', [InstrumentosRiasAPNAtnComplicacionesController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnAtnComplicaciones', [InstrumentosRiasAPNAtnComplicacionesController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnAtnComplicaciones/{id}', [InstrumentosRiasAPNAtnComplicacionesController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnAtnComplicaciones/{id}', [InstrumentosRiasAPNAtnComplicacionesController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnAtnComplicaciones/{id}', [InstrumentosRiasAPNAtnComplicacionesController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnSeguimientoRN', [InstrumentosRiasAPNSeguimientoRNController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnSeguimientoRN', [InstrumentosRiasAPNSeguimientoRNController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnSeguimientoRN/{id}', [InstrumentosRiasAPNSeguimientoRNController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnSeguimientoRN/{id}', [InstrumentosRiasAPNSeguimientoRNController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnSeguimientoRN/{id}', [InstrumentosRiasAPNSeguimientoRNController::class, 'obtenerHistoricoVersion']);

    Route::get('obtenerInstrumentosRiasApnAtnFamilias', [InstrumentosRiasAPNAtnFamiliasController::class, 'obtenerInstrumentos']);
    Route::post('crearInstrumentoRiasApnAtnFamilias', [InstrumentosRiasAPNAtnFamiliasController::class, 'crearInstrumento']);
    Route::put('actualizarInstrumentoRiasApnAtnFamilias/{id}', [InstrumentosRiasAPNAtnFamiliasController::class, 'actualizarInstrumento']);
    Route::put('activarInstrumentoRiasApnAtnFamilias/{id}', [InstrumentosRiasAPNAtnFamiliasController::class, 'activarInstrumento']);
    Route::get('obtenerHistoricoVersionRiasApnAtnFamilias/{id}', [InstrumentosRiasAPNAtnFamiliasController::class, 'obtenerHistoricoVersion']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/gestion-instrumentos'], function () {
    Route::get('obtenerInstrumentosActivosCalidad', [InstrumentosAudCalidadController::class, 'obtenerInstrumentosActivos']);
    Route::get('obtenerInstrumentoActivoPamec', [InstrumentosAudPamecController::class, 'obtenerInstrumentoActivo']);
    Route::get('obtenerInstrumentosActivosRiasPyM', [InstrumentosAudRiasPyMController::class, 'obtenerInstrumentosActivos']);
    Route::get('obtenerInstrumentosActivosRiasApn', [InstrumentosAudRiasAPNController::class, 'obtenerInstrumentosActivos']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/plan-visitas'], function() {
    Route::get('/obtenerPlanVisitasPorUsuario/{ano}/{mes}/{idUsuario}', [PlanVisitasController::class, 'obtenerPlanVisitasPorUsuario']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/plan-visitas-calidad'], function() {
    Route::get('/obtenerPlanVisitas/{auditor}/{ano}/{mes}', [PlanVisitasCalidadController::class, 'obtenerPlanVisitas']);
    Route::get('/buscarAsignacionPrestador/{ano}/{mes}/{idPrestador}', [PlanVisitasCalidadController::class, 'buscarAsignacionPrestador']);
    Route::post('/crearPlanVisitas', [PlanVisitasCalidadController::class, 'crearPlanVisitas']);
    Route::put('/actualizarFechaVisita/{idVisita}', [PlanVisitasCalidadController::class, 'actualizarFechaVisita']);
    Route::put('/eliminarPrestadorPlanVisitas/{idVisita}', [PlanVisitasCalidadController::class, 'eliminarPrestadorPlanVisitas']);
    Route::put('/actualizarSincronizacionVisita/{idVisita}', [PlanVisitasCalidadController::class, 'actualizarSincronizacionVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/plan-visitas-calidad'], function() {
    Route::put('/actualizarFechaVisita/{idVisita}', [PlanVisitasCalidadController::class, 'actualizarFechaVisita']);
    Route::put('/actualizarSincronizacionVisita/{idVisita}', [PlanVisitasCalidadController::class, 'actualizarSincronizacionVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/plan-visitas-pamec'], function() {
    Route::get('/obtenerPlanVisitas/{ano}/{mes}', [PlanVisitasPamecController::class, 'obtenerPlanVisitas']);
    Route::get('/obtenerPlanVisitasPorAuditor/{auditor}/{ano}/{mes}', [PlanVisitasPamecController::class, 'obtenerPlanVisitasPorAuditor']);
    Route::get('/obtenerPlanVisitasAnoPrestador/{ano}/{prestador}', [PlanVisitasPamecController::class, 'obtenerPlanVisitasAnoPrestador']);
    Route::get('/buscarAsignacionPrestador/{ano}/{mes}/{idPrestador}', [PlanVisitasPamecController::class, 'buscarAsignacionPrestador']);
    Route::post('/crearPlanVisitas', [PlanVisitasPamecController::class, 'crearPlanVisitas']);
    Route::put('/actualizarFechaVisita/{idVisita}', [PlanVisitasPamecController::class, 'actualizarFechaVisita']);
    Route::put('/eliminarPrestadorPlanVisitas/{idVisita}', [PlanVisitasPamecController::class, 'eliminarPrestadorPlanVisitas']);
    Route::put('/actualizarSincronizacionVisita/{idVisita}', [PlanVisitasPamecController::class, 'actualizarSincronizacionVisita']);

    Route::get('/obtenerSoporteVisita/{idSoporte}', [PlanVisitasPamecController::class, 'obtenerSoporteVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/plan-visitas-pamec'], function() {
    Route::put('/actualizarFechaVisita/{idVisita}', [PlanVisitasPamecController::class, 'actualizarFechaVisita']);
    Route::put('/actualizarSincronizacionVisita/{idVisita}', [PlanVisitasPamecController::class, 'actualizarSincronizacionVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/pamec'], function() {
    Route::post('/finalizarVisita', [PlanVisitasPamecController::class, 'finalizarVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/pamec'], function() {
    Route::get('/obtenerInstrumentoVisita/{idVisita}', [AuditoriaPamecController::class, 'obtenerInstrumentoVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/indicadores-pamec'], function() {
    Route::put('/actualizarIndicadores', [IndicadoresAuditoriaPamecController::class, 'actualizarIndicadores']);
    Route::get('/obtenerIndicadores/{ano}/{mes}/{municipio}/{prestador}/{visita}', [IndicadoresAuditoriaPamecController::class, 'obtenerIndicadores']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/plan-visitas-rias'], function() {
    Route::get('/obtenerPlanVisitas/{ano}/{mes}', [PlanVisitasRiasController::class, 'obtenerPlanVisitas']);
    Route::get('/obtenerAuditoresVisita/{idVisita}', [PlanVisitasRiasController::class, 'obtenerAuditoresVisita']);
    Route::get('/buscarAsignacionPrestador/{ano}/{mes}/{idPrestador}/{idSede}', [PlanVisitasRiasController::class, 'buscarAsignacionPrestador']);
    Route::post('/crearPlanVisitas', [PlanVisitasRiasController::class, 'crearPlanVisitas']);
    Route::put('/actualizarPlanVisitas/{idVisita}', [PlanVisitasRiasController::class, 'actualizarPlanVisitas']);
    Route::put('/eliminarPrestadorPlanVisitas/{idVisita}', [PlanVisitasRiasController::class, 'eliminarPrestadorPlanVisitas']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/plan-visitas-rias'], function() {
    Route::put('/actualizarFechaVisita/{idVisita}', [PlanVisitasRiasController::class, 'actualizarFechaVisita']);
    Route::put('/actualizarSincronizacionVisita/{idVisita}', [PlanVisitasRiasController::class, 'actualizarSincronizacionVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/plan-visitas-suh-3100'], function() {
    Route::get('/obtenerPlanVisitas/{ano}/{mes}', [PlanVisitasSuh3100Controller::class, 'obtenerPlanVisitas']);
    Route::get('/obtenerPlanVisitasAnoPrestador/{ano}/{prestador}', [PlanVisitasSuh3100Controller::class, 'obtenerPlanVisitasAnoPrestador']);
    Route::get('/obtenerAuditoresVisita/{idVisita}', [PlanVisitasSuh3100Controller::class, 'obtenerAuditoresVisita']);
    Route::get('/buscarAsignacionPrestador/{ano}/{mes}/{idPrestador}/{idSede}', [PlanVisitasSuh3100Controller::class, 'buscarAsignacionPrestador']);
    Route::post('/crearPlanVisitas', [PlanVisitasSuh3100Controller::class, 'crearPlanVisitas']);
    Route::put('/actualizarPlanVisitas/{idVisita}', [PlanVisitasSuh3100Controller::class, 'actualizarPlanVisitas']);
    Route::put('/eliminarPrestadorPlanVisitas/{idVisita}', [PlanVisitasSuh3100Controller::class, 'eliminarPrestadorPlanVisitas']);

    Route::get('/obtenerResumenServicioEstandar/{idVisita}', [PlanVisitasSuh3100Controller::class, 'obtenerResumenServicioEstandar']);
    Route::get('/obtenerSoportesVisita/{idVisita}', [PlanVisitasSuh3100Controller::class, 'obtenerSoportesVisita']);
    Route::get('/obtenerSoportesEspecificoVisita/{idSoporte}', [PlanVisitasSuh3100Controller::class, 'obtenerSoportesEspecificoVisita']);

    Route::post('/cargarInformeFinalVisita', [PlanVisitasSuh3100Controller::class, 'cargarInformeFinalVisita']);
    Route::get('/descargarInformeFinalVisita/{idArchivo}', [PlanVisitasSuh3100Controller::class, 'descargarInformeFinalVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid,ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/plan-visitas-suh-3100'], function() {
    Route::get('/obtenerServiciosVisita/{idVisita}', [PlanVisitasSuh3100Controller::class, 'obtenerServiciosVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/plan-visitas-suh-3100'], function() {
    Route::put('/actualizarSincronizacionVisita/{idVisita}', [PlanVisitasSuh3100Controller::class, 'actualizarSincronizacionVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-aud-mob', 'urlFilter'], 'prefix' => 'v1/suh-3100'], function() {
    Route::post('/finalizarVisita', [PlanVisitasSuh3100Controller::class, 'finalizarVisita']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/indicadores-suh-3100'], function() {
    Route::put('/actualizarIndicadores', [IndicadoresSuh3100Controller::class, 'actualizarIndicadores']);
    Route::get('/obtenerIndicadores/{ano}/{mes}/{municipio}/{prestador}/{sede}/{servicio}/{visita}', [IndicadoresSuh3100Controller::class, 'obtenerIndicadores']);
});

Route::group(['middleware' => ['auth:api', 'scope:ver-adm-lid,ver-lid', 'urlFilter'], 'prefix' => 'v1/consolidacion-indicadores'], function() {
    Route::put('/consolidarIndicadores/{ano}/{mes}', [ConsolidacionIndicadoresController::class, 'consolidarIndicadores']);
    Route::get('/obtenerEstadoConsolidacion', [ConsolidacionIndicadoresController::class, 'obtenerEstadoConsolidacion']);
});
