<?php

namespace App\Http\Controllers;

use App\Models\Parametros;
use Illuminate\Http\Request;

class ParametrosController extends Controller
{

    public function crearParametro(Request $request) {
        $parametro = Parametros::on('costos_principal');

        $par_mes = $request->input("par_mes") == "" ? null : $request->input("par_mes");

        $id = $parametro->create(
            [
                "con_fk_id" => $request->input("con_fk_id"),
                "ins_fk_id" => $request->input("ins_fk_id"),
                "par_ano" => $request->input("par_ano"),
                "par_mes" => $par_mes,
                "par_parametro" => $request->input("par_parametro"),
                "par_valor" => $request->input("par_valor")
            ]
        );

        return array("response" => $id->par_pk_id);
    }

    public function actualizarParametro(Request $request) {
        $par_mes = $request->input("par_mes") == "" ? null : $request->input("par_mes");

        if ($par_mes == null) {
            Parametros::on('costos_principal')
                    ->where("con_fk_id", $request->input("con_fk_id"))
                    ->where("ins_fk_id", $request->input("ins_fk_id"))
                    ->where("par_ano", $request->input("par_ano"))
                    ->where("par_parametro", $request->input("par_parametro"))
            ->update(
                [
                    "par_valor" => $request->input("par_valor")
                ]
            );
        } else {
            Parametros::on('costos_principal')
                    ->where("con_fk_id", $request->input("con_fk_id"))
                    ->where("ins_fk_id", $request->input("ins_fk_id"))
                    ->where("par_ano", $request->input("par_ano"))
                    ->where("par_mes", $par_mes)
                    ->where("par_parametro", $request->input("par_parametro"))
            ->update(
                [
                    "par_valor" => $request->input("par_valor")
                ]
            );
        }
    }

    public function getParametro(Request $request) {
        $par_mes = $request->input("par_mes") == "" ? null : $request->input("par_mes");

        if ($par_mes == null) {
            return Parametros::on('costos_principal')
                            ->select('par_valor')
                            ->where('con_fk_id', $request->input('con_fk_id'))
                            ->where('ins_fk_id', $request->input('ins_fk_id'))
                            ->where('par_ano', $request->input('par_ano'))
                            ->where('par_parametro', $request->input('par_parametro'))
                            ->get()->toArray();
        } else {
            return Parametros::on('costos_principal')
                            ->select('par_valor')
                            ->where('con_fk_id', $request->input('con_fk_id'))
                            ->where('ins_fk_id', $request->input('ins_fk_id'))
                            ->where('par_ano', $request->input('par_ano'))
                            ->where('par_mes', $par_mes)
                            ->where('par_parametro', $request->input('par_parametro'))
                            ->get()->toArray();
        }

    }
}
