<?php

namespace App\Http\Controllers;

use App\Models\SedesReps;
use Illuminate\Http\Request;

class SedesRepsController extends Controller
{
    public function crearSedesReps(Request $request) {
        $sedes = $request->input('sedes');
        $codHabilitacion = $request->input('codHabilitacion');

        foreach($sedes as $sede) {
            $registro = SedesReps::on('costos_principal');

            $id = $registro->create(
                [
                    "inr_fk_id" => $codHabilitacion,
                    "ser_nombre_sede" => $sede['ser_nombre_sede'],
                    "ser_direccion" => $sede['ser_direccion'],
                    "ser_sede_activa" => true
                ]
            );
        }
    }

    public function getSedePorCodigo(Request $request) {
        return SedesReps::on('costos_principal')
                        ->where('inr_fk_id', $request->input('inr_fk_id'))->get()->toArray();
    }

    public function actualizarSedesReps(Request $request) {
        $sedes = $request->input('sedes');
        $codHabilitacion = $request->input('codHabilitacion');

        foreach($sedes as $sede) {
            if (!$sede['modificable']) {
                SedesReps::on('costos_principal')
                        ->where('inr_fk_id', $codHabilitacion)
                        ->where('ser_pk_id', $sede['ser_pk_id'])
                        ->update(
                            [
                                "ser_nombre_sede" => $sede['ser_nombre_sede'],
                                "ser_direccion" => $sede['ser_direccion'],
                                "ser_sede_activa" => $sede['ser_sede_activa']
                            ]
                        );
            } else {
                $registro = SedesReps::on('costos_principal');

                $id = $registro->create(
                    [
                        "inr_fk_id" => $codHabilitacion,
                        "ser_nombre_sede" => $sede['ser_nombre_sede'],
                        "ser_direccion" => $sede['ser_direccion'],
                        "ser_sede_activa" => $sede['ser_sede_activa']
                    ]
                );
            }
        }
    }
}
