<?php

namespace App\Http\Controllers;

use App\Models\UsoModulos;
use App\Models\Usuarios;
use Illuminate\Http\Request;

class UsoModulosController extends Controller
{
    public function solicitarAccesoModulo(Request $request) {
        $contrato = $request->input("con_fk_id");
        $institucion = $request->input("ins_fk_id");
        $ano = $request->input('umo_ano');
        $mes = $request->input('umo_mes');
        $usuario = $request->input("usu_fk_id");
        $modulo = $request->input("mod_fk_id");

        $rolUsuario = Usuarios::on('costos_principal')->where('usu_pk_id', $usuario)->value('rol_fk_id');

        if ($rolUsuario != 3) { // El usuario de consulta no necesita permiso
            $usuariosActivos = \DB::select("
                select *
                from costos_principal.uso_modulos as umo
                join costos_principal.usuarios on (usu_pk_id = usu_fk_id)
                where umo.con_fk_id = ".$contrato." and
                      umo.ins_fk_id = '".$institucion."' and
                      mod_fk_id = ".$modulo." and
                      umo_ano = ".$ano." and
                      umo_mes = ".$mes." and
                      extract(epoch from current_timestamp - cast(umo_ultima_accion as timestamp)) < 1200
            ");

            if (count($usuariosActivos) == 0) { // No hay usuarios activos
                // Eliminar otros usuarios del modulo
                UsoModulos::on('costos_principal')
                        ->where('con_fk_id', $contrato)
                        ->where('ins_fk_id', $institucion)
                        ->where('mod_fk_id', $modulo)
                        ->where('umo_ano', $ano)
                        ->where('umo_mes', $mes)
                        ->delete();

                // Eliminar cualquier otra actividad del usuario entrante
                UsoModulos::on('costos_principal')
                          ->where('con_fk_id', $contrato)
                          ->where('ins_fk_id', $institucion)
                          ->where('usu_fk_id', $usuario)
                          ->delete();

                // Crear el nuevo registro de acitividad
                UsoModulos::on('costos_principal')->create(
                    [
                        "con_fk_id" => $contrato,
                        "ins_fk_id" => $institucion,
                        "usu_fk_id" => $usuario,
                        "mod_fk_id" => $modulo,
                        "umo_ano" => $ano,
                        "umo_mes" => $mes,
                        "umo_ultima_accion" => "now()"
                    ]
                );

                return array("response" => 1);
            } else if ($usuariosActivos[0]->usu_fk_id == $usuario) { // El usuario retomo su actividad después de un cierre incorrecto
                UsoModulos::on('costos_principal')
                        ->where('con_fk_id', $contrato)
                        ->where('ins_fk_id', $institucion)
                        ->where('usu_fk_id', $usuario)
                        ->where('mod_fk_id', $modulo)
                        ->where('umo_ano', $ano)
                        ->where('umo_mes', $mes)
                ->update(["umo_ultima_accion" => "now()"]);

                return array("response" => 1);
            }

            return array("response" => 0, "usuario" => $usuariosActivos[0]->usu_cuenta);
        } else {
            return array("response" => 2);
        }
    }

    public function verificarAccesoModulo(Request $request) {
        $contrato = $request->input("con_fk_id");
        $institucion = $request->input("ins_fk_id");
        $ano = $request->input('umo_ano');
        $mes = $request->input('umo_mes');
        $usuario = $request->input("usu_fk_id");
        $modulo = $request->input("mod_fk_id");

        return UsoModulos::on('costos_principal')
                         ->where('con_fk_id', $contrato)
                         ->where('ins_fk_id', $institucion)
                         ->where('usu_fk_id', $usuario)
                         ->where('mod_fk_id', $modulo)
                         ->where('umo_ano', $ano)
                         ->where('umo_mes', $mes)
                         ->count();
    }

    public function actualizarUltimaAccionModulo(Request $request) {
        $contrato = $request->input("con_fk_id");
        $institucion = $request->input("ins_fk_id");
        $ano = $request->input('umo_ano');
        $mes = $request->input('umo_mes');
        $usuario = $request->input("usu_fk_id");
        $modulo = $request->input("mod_fk_id");

        UsoModulos::on('costos_principal')
                  ->where('con_fk_id', $contrato)
                  ->where('ins_fk_id', $institucion)
                  ->where('umo_ano', $ano)
                  ->where('umo_mes', $mes)
                  ->where('usu_fk_id', $usuario)
                  ->where('mod_fk_id', $modulo)
        ->update(
            [
                "umo_ultima_accion" => "now()"
            ]
        );
    }

    public function liberarModulo(Request $request) {
        $contrato = $request->input("con_fk_id");
        $institucion = $request->input("ins_fk_id");
        $ano = $request->input('umo_ano');
        $mes = $request->input('umo_mes');
        $usuario = $request->input("usu_fk_id");
        $modulo = $request->input("mod_fk_id");

        UsoModulos::on('costos_principal')
                  ->where('con_fk_id', $contrato)
                  ->where('ins_fk_id', $institucion)
                  ->where('usu_fk_id', $usuario)
                  ->where('mod_fk_id', $modulo)
                  ->where('umo_ano', $ano)
                  ->where('umo_mes', $mes)
                  ->delete();
    }

    public function reestablecerActividadUsuario(Request $request) {
        $contrato = $request->input("con_fk_id");
        $institucion = $request->input("ins_fk_id");
        $usuario = $request->input("usu_fk_id");

        UsoModulos::on('costos_principal')
                  ->where('con_fk_id', $contrato)
                  ->where('ins_fk_id', $institucion)
                  ->where('usu_fk_id', $usuario)
                  ->delete();
    }
}
