<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Contrato extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contrato', function (Blueprint $table) {
            $table->increments('con_pk_id');
            $table->string('con_id_contrato', 200);
            $table->integer('con_no_usuarios');
            $table->string('con_nit', 50);
            $table->string('con_razon_social', 250);
            $table->string('con_rep_legal', 200);
            $table->string('con_correo_rep', 200);
            $table->string('con_direccion', 200);
            $table->integer('dep_fk_id');
            $table->string('con_ciudad', 200);
            $table->date('con_fecha_inicio');
            $table->date('con_fecha_fin');
            $table->date('con_fecha_inicio_carga');
            $table->date('con_fecha_fin_carga');
            $table->string('con_logo', 1000)->nullable();

            // Llaves foraneas
            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos')->onDelete('cascade');

            $table->index('con_id_contrato');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contrato');
    }
}
