<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DistribucionCostosBases extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('distribucion_costos_bases', function (Blueprint $table) {
            $table->increments('dcb_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('dcb_ano');
            $table->integer('cco_fk_id');
            $table->integer('bdi_fk_id');
            $table->float('dcb_ponderacion');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('bdi_fk_id')->references('bdi_pk_id')->on('bases_distribucion')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'dcb_ano', 'cco_fk_id', 'bdi_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'dcb_ano'], 'dcb_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'dcb_ano', 'cco_fk_id'], 'dcb_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'dcb_ano', 'cco_fk_id', 'bdi_fk_id'], 'dcb_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('distribucion_costos_bases');
    }
}
