<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DistribucionIfmCostosBases extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('distribucion_ifm_costos_bases', function (Blueprint $table) {
            $table->increments('dib_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('dib_ano');
            $table->integer('dib_mes');
            $table->integer('ifm_fk_id');
            $table->integer('bdi_fk_id');
            $table->float('dib_ponderacion');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('ifm_fk_id')->references('ifm_pk_id')->on('informacion_financiera')->onDelete('cascade');
            $table->foreign('bdi_fk_id')->references('bdi_pk_id')->on('bases_distribucion')->onDelete('cascade');

            $table->index('ifm_fk_id');
            $table->index('bdi_fk_id');
            $table->index(['con_fk_id', 'ins_fk_id', 'dib_ano', 'dib_mes']);

            $table->unique(['con_fk_id', 'ins_fk_id', 'dib_ano', 'dib_mes', 'ifm_fk_id', 'bdi_fk_id'], 'dib_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('distribucion_ifm_costos_bases');
    }
}
