<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ValorMinuto extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('valor_minuto', function (Blueprint $table) {
            $table->increments('vam_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('vam_ano');
            $table->integer('vam_mes');
            $table->integer('mob_fk_id');
            $table->integer('cco_fk_id');
            $table->float('vam_valor_minuto');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('mob_fk_id')->references('mob_pk_id')->on('mano_obra')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'vam_ano', 'vam_mes']);
            $table->index(['con_fk_id', 'ins_fk_id', 'vam_ano', 'vam_mes', 'mob_fk_id']);
            $table->index(['con_fk_id', 'ins_fk_id', 'vam_ano', 'vam_mes', 'cco_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('valor_minuto');
    }
}
