<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UsoModulos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('uso_modulos', function (Blueprint $table) {
            $table->bigIncrements('umo_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('usu_fk_id');
            $table->integer('mod_fk_id');
            $table->integer('umo_ano');
            $table->integer('umo_mes');
            $table->dateTime('umo_ultima_accion');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('usu_fk_id')->references('usu_pk_id')->on('usuarios')->onDelete('cascade');
            $table->foreign('mod_fk_id')->references('mod_pk_id')->on('modulos')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'mod_fk_id', 'usu_fk_id', 'umo_ano', 'umo_mes']);

            $table->index(['con_fk_id', 'ins_fk_id', 'usu_fk_id', 'mod_fk_id', 'umo_ano', 'umo_mes'], 'umo_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('uso_modulos');
    }
}
