<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

class InstrumentosAudRiasPyMController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentosActivos(Request $request) {
        return DB::connection($this->cliente)->select("
            select irt_pk_id as irp_pk_id, irt_version as irp_version, irt_comentarios as irp_comentarios, irt_instrumento as irp_instrumento
            from instrumentos_rias_pym_transversales
            where irt_activa = true

            union all

            select irp_pk_id, irp_version, irp_comentarios, irp_instrumento
            from instrumentos_rias_pym_prim_infancia
            where irp_activa = true

            union all

            select iri_pk_id, iri_version, iri_comentarios, iri_instrumento
            from instrumentos_rias_pym_infancia
            where iri_activa = true

            union all

            select ira_pk_id, ira_version, ira_comentarios, ira_instrumento
            from instrumentos_rias_pym_adolescencia
            where ira_activa = true

            union all

            select irj_pk_id, irj_version, irj_comentarios, irj_instrumento
            from instrumentos_rias_pym_juventud
            where irj_activa = true

            union all

            select ird_pk_id, ird_version, ird_comentarios, ird_instrumento
            from instrumentos_rias_pym_adultez_hombres
            where ird_activa = true

            union all

            select ird_pk_id, ird_version, ird_comentarios, ird_instrumento
            from instrumentos_rias_pym_adultez_mujeres
            where ird_activa = true

            union all

            select irv_pk_id, irv_version, irv_comentarios, irv_instrumento
            from instrumentos_rias_pym_vejez_hombres
            where irv_activa = true

            union all

            select irv_pk_id, irv_version, irv_comentarios, irv_instrumento
            from instrumentos_rias_pym_vejez_mujeres
            where irv_activa = true
        ");
    }
}
