<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasAPNEmerObstetrica;
use App\Models\clientes\HistoricoInsRiasAPNEmerObstetrica;

class InstrumentosRiasAPNEmerObstetricaController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasAPNEmerObstetrica::on($this->cliente)
                                                ->orderBy('ire_activa', 'desc')
                                                ->orderBy('ire_pk_id', 'desc')
                                                ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_apn_emer_obstetrica\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasAPNEmerObstetrica::on($this->cliente)->create([
                'ire_version' => $nuevaVersion,
                'ire_comentarios' => $request->ire_comentarios,
                'ire_instrumento' => json_encode($request->ire_instrumento),
                'ire_usu_creacion' => $usuario
            ])->ire_pk_id;

            HistoricoInsRiasAPNEmerObstetrica::on($this->cliente)->create([
                'ire_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hre_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasAPNEmerObstetrica::on($this->cliente)->where('ire_pk_id', $id)->update([
                'ire_comentarios' => $request->ire_comentarios,
                'ire_instrumento' => $request->ire_instrumento
            ]);

            HistoricoInsRiasAPNEmerObstetrica::on($this->cliente)->create([
                'ire_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hre_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasAPNEmerObstetrica::on($this->cliente)
                                                        ->where('ire_activa', true)
                                                        ->pluck('ire_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasAPNEmerObstetrica::on($this->cliente)->where('ire_pk_id', $idActivo)->update([
                'ire_activa' => false
            ]);

            HistoricoInsRiasAPNEmerObstetrica::on($this->cliente)->create([
                'ire_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hre_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasAPNEmerObstetrica::on($this->cliente)->where('ire_pk_id', $id)->update([
                'ire_activa' => true
            ]);

            HistoricoInsRiasAPNEmerObstetrica::on($this->cliente)->create([
                'ire_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hre_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasAPNEmerObstetrica::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_apn_emer_obstetrica.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('ire_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
