<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasPyMAdolescencia;
use App\Models\clientes\HistoricoInsRiasPyMAdolescencia;

class InstrumentosRiasPyMAdolescenciaController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasPyMAdolescencia::on($this->cliente)
                                               ->orderBy('ira_activa', 'desc')
                                               ->orderBy('ira_pk_id', 'desc')
                                               ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_pym_adolescencia\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasPyMAdolescencia::on($this->cliente)->create([
                'ira_version' => $nuevaVersion,
                'ira_comentarios' => $request->ira_comentarios,
                'ira_instrumento' => json_encode($request->ira_instrumento),
                'ira_usu_creacion' => $usuario
            ])->ira_pk_id;

            HistoricoInsRiasPyMAdolescencia::on($this->cliente)->create([
                'ira_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hra_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasPyMAdolescencia::on($this->cliente)->where('ira_pk_id', $id)->update([
                'ira_comentarios' => $request->ira_comentarios,
                'ira_instrumento' => $request->ira_instrumento
            ]);

            HistoricoInsRiasPyMAdolescencia::on($this->cliente)->create([
                'ira_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hra_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasPyMAdolescencia::on($this->cliente)
                                            ->where('ira_activa', true)
                                            ->pluck('ira_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasPyMAdolescencia::on($this->cliente)->where('ira_pk_id', $idActivo)->update([
                'ira_activa' => false
            ]);

            HistoricoInsRiasPyMAdolescencia::on($this->cliente)->create([
                'ira_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hra_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasPyMAdolescencia::on($this->cliente)->where('ira_pk_id', $id)->update([
                'ira_activa' => true
            ]);

            HistoricoInsRiasPyMAdolescencia::on($this->cliente)->create([
                'ira_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hra_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasPyMAdolescencia::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_pym_adolescencia.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('ira_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
